import pandas as pd
import numpy as np
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

# Calculate head-to-head win rates  
h2h_win_rates = calculate_head_to_head_win_rate(atp_tennis)  
print(h2h_win_rates)
  
# Initialize an empty DataFrame for storing the results  
updated_odds_df = pd.DataFrame(columns=['Match ID', 'Original Odd_1', 'Original Odd_2', 'Updated Odd_1', 'Updated Odd_2'])  

# Loop through the affected matches  
for match_id in federer_match_ids:  
    # Update the odds for the match  
    updated_odd_1, updated_odd_2 = update_odds(match_id, 0.7, 0.3, atp_tennis, h2h_win_rates)  
  
    # Append the results to the DataFrame  
    original_odd_1 = atp_tennis.loc[match_id, 'Odd_1']  
    original_odd_2 = atp_tennis.loc[match_id, 'Odd_2']  
    updated_odds_df = pd.concat([updated_odds_df, pd.DataFrame({'Match ID': [match_id], 'Original Odd_1': [original_odd_1], 'Original Odd_2': [original_odd_2], 'Updated Odd_1': [updated_odd_1], 'Updated Odd_2': [updated_odd_2]})], ignore_index=True)  

# Display the resulting DataFrame  
print(updated_odds_df)
pickle.dump(updated_odds_df,open("./ref_result/updated_odds_df.pkl","wb"))  